module CNT_1S_40S(clk,pulse,cnt1S,cnt40S);
input clk;
input pulse;
output [31:0] cnt1S;
output [31:0] cnt40S;

reg [31:0] cnt1S;
reg [31:0] cnt40S;
reg [34:0] x8_cnt1S;
reg [34:0] x8_cnt40S;
reg shift_pulse;
reg [7:0] Timer_40S;


always@(posedge clk)begin
	shift_pulse <= pulse;
end

always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1)
		x8_cnt1S <=4;
	else if(x8_cnt1S != 100*1000*1000)
		x8_cnt1S <=x8_cnt1S + 1'b1;	
	else
		x8_cnt1S <=x8_cnt1S;			
end

always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1)
		cnt1S <=x8_cnt1S[34:3];
	else
		cnt1S <=cnt1S;				
end

always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1 && Timer_40S==39 )
		x8_cnt40S <=4;
	else if(x8_cnt40S != 40*100*1000*1000)
		x8_cnt40S <=x8_cnt40S + 1'b1;	
	else
		x8_cnt40S <=x8_cnt40S;			
end


always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1 && Timer_40S==39 )
		cnt40S <=x8_cnt40S[34:3];
	else
		cnt40S <=cnt40S;				
end




always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1 && Timer_40S==39)
		Timer_40S <=0;
	else if(shift_pulse==0 && pulse==1)
		Timer_40S <=Timer_40S + 1'b1;
	else
		Timer_40S <=Timer_40S;			
end



endmodule


module SOKUDO_PLL(clk,pulse,dac);
input clk;
input pulse;
output [15:0] dac;
reg signed [16:0] pre_dac;
reg [34:0] x8_cnt1S;
reg shift_pulse;

always@(posedge clk)begin
	shift_pulse <= pulse;
end


always@(posedge clk)begin
	if(pre_dac <=0)
		pre_dac <= 32768;

		
	else if(shift_pulse==0 && pulse==1  && Timer_40S==9 && 80000000*10 > x8_cnt40S +8  && x8_cnt40S >  80000000*10-500)
		pre_dac <=pre_dac + (80000000*10 - x8_cnt40S)*40;
	else if(shift_pulse==0 && pulse==1  && Timer_40S==9 && 80000000*10 +8 < x8_cnt40S  && x8_cnt40S <  80000000*10+500)
		pre_dac <=pre_dac + (80000000*10 - x8_cnt40S)*40;
	
	else if(shift_pulse==0 && pulse==1 && x8_cnt1S >  80000000 - 10000  &&  x8_cnt1S <  80000000 + 10000)
		pre_dac <=pre_dac + (80000000 - x8_cnt1S)*9;	
		
	else
		pre_dac <= pre_dac;
end


assign dac = pre_dac[15:0];



always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1)
		x8_cnt1S <=1;
	else if(x8_cnt1S != 100*1000*1000)
		x8_cnt1S <=x8_cnt1S + 1'b1;	
	else
		x8_cnt1S <=x8_cnt1S;	
				
end


reg [34:0] x8_cnt40S;


always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1 && Timer_40S==9)
		x8_cnt40S <=1;
	else if(x8_cnt1S != 10*100*1000*1000)
		x8_cnt40S <=x8_cnt40S + 1'b1;	
	else
		x8_cnt40S <=x8_cnt40S;	
				
end


reg [9:0] Timer_40S;


always@(posedge clk)begin
	if(shift_pulse==0 && pulse==1 && Timer_40S==9)
		Timer_40S <=0;
	else if(shift_pulse==0 && pulse==1)
		Timer_40S <=Timer_40S + 1'b1;
	else
		Timer_40S <=Timer_40S;			
end


endmodule


module DAC_SPI(clk,pulse,dac,sck,sdi,cs,dac_latch);

input clk;
input pulse;
input [15:0] dac;
output sck;
output sdi;
output cs;
output [15:0] dac_latch;

reg [15:0] shift_dac;
reg [24:0] shift_sdo_x;
reg shift_pulse;
reg [2:0] toggle;
reg [6:0] sdo_cnt;
reg cs;
reg sck;
reg [15:0] dac_latch;

always@(posedge clk)begin
	if(shift_pulse==0 &&  pulse==1)begin
		dac_latch <= shift_dac;
	end
	else begin
		dac_latch <= dac_latch; 		
	end
end

always@(posedge clk)begin
	shift_pulse <= pulse;
	shift_dac <= dac;
end

always@(posedge clk)begin
	if(shift_pulse==0 &&  pulse==1)
		toggle <= 0;
	else if(toggle==3)
		toggle <= 0;
	else
		toggle <= toggle+1'b1; 		
		
end

always@(posedge clk)begin
	if(shift_pulse==0 &&  pulse==1)
		sdo_cnt <= 0;
	else if(sdo_cnt != 30 && toggle ==3)
		sdo_cnt <= sdo_cnt + 1'b1; 	
	else
		sdo_cnt <= sdo_cnt;
end

always@(posedge clk)begin
	if(shift_pulse==0 &&  pulse==1)begin
		shift_sdo_x <= {8'h0,shift_dac};
	end
	else if(toggle==0)begin
		shift_sdo_x[24:1] <= shift_sdo_x[23:0] ;
		shift_sdo_x[0] <= 0; 
	end
	else begin
		shift_sdo_x <= shift_sdo_x; 		
	end
end

assign sdi = shift_sdo_x[24];

always @(posedge clk)begin
	if(sdo_cnt < 24)
		cs <= 0;
	else if(sdo_cnt > 25)
		cs <= 0;
	else
		cs <= 1;
end

always @(posedge clk)begin
	if(sdo_cnt < 24)
		sck <= ~toggle[1];
	else
		sck <= 1;
end




endmodule





module SPI(cs,spck,sdi,sdo,m_clk,cnt1S,cnt40S,dac,jitter);

input spck;
input sdi;
input m_clk;
input cs;
output sdo;




input [31:0] cnt1S;
input [31:0] cnt40S;
input [15:0] dac;
input [15:0] jitter;

wire fifo_out;
wire empty;
reg [23:0] shift_reg;   // Addr(8bit)+Data(16bit)    
reg [7:0] shift_cnt;

reg shift_empty;
reg shift_spck;
reg shift_shift_spck;



reg [16:0] shift_sdo;

MY_FIFO INST_FIFO1(
	.idata(sdi),
	.ock(m_clk),
	.ick(spck),
	.odata(fifo_out),
	.empty(empty));

	
always@(posedge m_clk)begin
	if(shift_empty==0)begin
		shift_reg[23:1] <= shift_reg[22:0];
		shift_reg[0] <= fifo_out;
	end
	else
		shift_reg <= shift_reg;		
end

always@(posedge m_clk)begin
	//if(shift_cs== 0 && cs==1)
	if(cs==0)
		shift_cnt <= 0;
	else if(cs==1 && shift_empty==0 && shift_cnt != 250)
		shift_cnt <= shift_cnt + 1'b1;
	else
		shift_cnt <= shift_cnt;		
end



always@(posedge m_clk)begin
	shift_empty <= empty;
	shift_spck <= spck;	
	shift_shift_spck <= shift_spck;		
//	shift_shift_shift_spck <= shift_shift_spck;
	//shift_cs <= cs;
end





/*

always@(posedge m_clk)begin
	if(shift_cnt == 23 && shift_empty==0 && shift_reg[21:15]==25 && shift_reg[22]==0)
		width3[19:16] <= {shift_reg[2:0],fifo_out};
	else
		width3[19:16] <= width3[19:16];		
end

*/
always@(posedge m_clk)begin
	if(cs==0)
		shift_sdo<= 0;
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==0)
		shift_sdo <= cnt1S[15:0];		
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==1)
		shift_sdo <= cnt1S[31:16];	
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==2)
		shift_sdo <= cnt40S[15:0];		
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==3)
		shift_sdo <= cnt40S[31:16];	
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==4)
		shift_sdo <= dac;	
	else if(shift_cnt == 7 && shift_empty==0 && {shift_reg[5:0],fifo_out}==5)
		shift_sdo <= jitter;	
		
	else if(shift_spck==0 && shift_shift_spck==1) begin
		shift_sdo[16:1] <= shift_sdo[15:0];
		shift_sdo[0]   <= 0;
	end
	else
		shift_sdo<= shift_sdo;
end


assign sdo=shift_sdo[16];

endmodule







module MY_FIFO(ick,ock, idata,odata,empty);

input ick;
input ock;
output odata;
input idata;
output empty;

//reg odata;
reg shift_ick;
reg shift_shift_ick;
//reg shift_shift_shift_ick;

assign empty =  ~((~ shift_shift_ick ) & shift_ick);

always@(posedge ock)begin
	shift_ick <= ick;
	shift_shift_ick <= 	shift_ick;
//	shift_shift_shift_ick <= 	shift_shift_ick;	
end

/*always@(posedge ock)begin
	if(empty==0)
		odata <= idata;	
	else
		odata <= odata;
end*/

assign odata=idata;

endmodule


module Unti_Chatter(inpulse,m_clk,outpulse);
input inpulse;
input m_clk;
output outpulse;

reg outpulse;
reg [799:0] shift_reg;   //800bit = 10uS

always@(posedge m_clk)begin
	shift_reg[0] <= inpulse;
	shift_reg[799:1] <= shift_reg[798:0] ;	
end


always@(posedge m_clk)begin
	if(shift_reg)
		outpulse <= 1;
	else
		outpulse <= 0;	
end

endmodule


module delay(inpulse,m_clk,outpulse);
input inpulse;
input m_clk;
output outpulse;

reg outpulse;
reg [799:0] shift_reg;   //800bit = 10uS

always@(posedge m_clk)begin
	shift_reg[0] <= inpulse;
	shift_reg[799:1] <= shift_reg[798:0] ;	
end


always@(posedge m_clk)begin
	outpulse <= shift_reg[200];	
end

endmodule




module PHASE_PLL(clk,pulse,dac,jitter);
input clk;
input pulse;
output [15:0] dac;
output [15:0] jitter;


reg signed [32:0] pre_dac1;
reg signed [32:0] pre_dac2;
reg shift_pulse;

always@(posedge clk)begin
	shift_pulse <= pulse;
end

reg [31:0] init_cnt;
always@(posedge clk)begin
	if(init_cnt < 100*1000*1000-1)
		init_cnt <= init_cnt + 1'b1;
	else
		init_cnt <= init_cnt;
end


reg [34:0] div;
always@(posedge clk)begin
	if(init_cnt < 90*1000*1000-1 && shift_pulse==0 && pulse==1)
		div <= 0;		
	else if(div==80*1000*1000-1)
		div <= 0;
	else
		div <= div + 1'b1;
end

reg signed [16:0] state;


always@(posedge clk)begin
	if(init_cnt < 95*1000*1000-1 && pulse==0)
		state <= 0;		
	else if(state==0 && div==0 && shift_pulse==0 && pulse==1)
		state <= 0;
	else if(state==0 && div==0)
		state <= -1;
	else if(state==0 &&  shift_pulse==0 && pulse==1)
		state <= 1;
		
	else if(state==1 && div==0)
		state <= 0;
	else if(state==-1 && shift_pulse==0 && pulse==1)
		state <= 0;
	else
		state <= state;
end


reg signed [40:0] sekibun;
reg signed [15:0] jitter;


always@(posedge clk)begin
	if(init_cnt < 95*1000*1000-1)
		sekibun <= 33700*64+st_trg;
	else
		sekibun <= sekibun + state;
end

always@(posedge clk)begin
	if(div==80*1000*1000-300)
		jitter <= 1000;
	else
		jitter <= jitter + state;
end


reg st_trg;

always@(posedge clk)begin
	if( div ==0)
		st_trg <= 1;
	else
		st_trg <= 0;
end



always@(posedge clk)begin
	pre_dac1 <= 8192*state + sekibun/64;
end

always@(posedge clk)begin
	if(init_cnt < 95*1000*1000-1)
	pre_dac2 <= 33700*256;	
	else
	pre_dac2 <= pre_dac2 +(pre_dac1  - pre_dac2/256);
end

assign dac = pre_dac2/256;




endmodule
